/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.ethernet;

import com.gprinter.udp.CommandUDP;
import com.gprinter.utils.NetworkUtils;
import java.nio.charset.Charset;

public class SettingDHCPTimeoutCommand
extends CommandUDP {
    private byte[] mac = new byte[6];
    private int timeout;
    private boolean valid;
    private static final byte[] tmp = "YJKE02GPRINTERGPt".getBytes(Charset.forName("ascii"));

    public SettingDHCPTimeoutCommand(String mac, int timeout) {
        this.timeout = timeout;
        this.valid = NetworkUtils.getMac(mac, this.mac);
    }

    public SettingDHCPTimeoutCommand(byte[] mac, int timeout) {
        if (mac != null && mac.length >= 6) {
            System.arraycopy(mac, 0, this.mac, 0, 6);
            this.timeout = timeout;
            this.valid = true;
        } else {
            this.valid = false;
        }
    }

    @Override
    public byte[] getCommand() {
        if (this.valid) {
            String ts = Integer.toString(this.timeout);
            byte[] tss = ts.getBytes(Charset.forName("ascii"));
            byte[] data = new byte[9 + tmp.length + tss.length];
            data[0] = 66;
            data[1] = 91;
            System.arraycopy(this.mac, 0, data, 2, 6);
            data[8] = 93;
            System.arraycopy(tmp, 0, data, 9, tmp.length);
            System.arraycopy(tss, 0, data, 9 + tmp.length, tss.length);
            return data;
        }
        return null;
    }
}

